
#------------------------------------------------------------
# Kreuzungsampel_mitAnforderung_CLUSB4.py                  Victor Klein 1.1.07
# Test der Kreuzungsampel mit beiden Ampeln
# Zusaetzlich wird die Anforderung der Fussgaengerampel bearbeitet
# keine Verwendung von Threads, kann aus der IDLE gestartet werden
#-----------------------------------------------------------
from CompulabUSB4 import *
from time import *

class kreuzung(object):

    def __init__(self):
        self.outwert = 0
        self.test = 1
        self.wartezeit = 0.05
        self.kenntFussampel = 0
        self.angefordert = False
        self.cl1 = CompulabUSB4()        # Interfaceobjekt 1 schaffen
        self.cl1.INIT(1)                 # und mit 1-tem Compulab verbinden
        self.bitliste = [0,0,0,0,0,0,0,0,0] # b7 b6 b5 b4 b3 b2 b1 b0

    def macheFussampelBekannt(self,eineAmpel):
        self.kenntFussampel = eineAmpel

    def warte_und_frageAb(self,zeit):
        index = zeit * 10
        while index > 0:
            sleep(self.wartezeit)
            index = index -1
            if self.kenntFussampel.angefordert():
                self.angefordert = True
                print "Fussgaengerampel angefordert"
        
    def berechne(self):
        wert = 0
        for i in self.bitliste:
           wert = 2* wert + i
        return wert
    
    def bitaus(self,nr):
        self.bitliste[8-nr] = 0
        self.outwert = self.berechne()
        if self.test:
            print self.bitliste,"bitaus", self.outwert
        self.cl1.DOUT(self.outwert)
        
    def bitan (self,nr):
        self.bitliste[8-nr] = 1
        self.outwert = self.berechne()
        if self.test:
            print self.bitliste,"bitaus", self.outwert
        self.cl1.DOUT(self.outwert)
            
    def startzustand(self):
        self.bitan(5) # A2 gruen
        self.bitan(0) # A1 rot
        self.warte_und_frageAb(5)
        
    def nachAmpel_1_gruen(self):
        
        self.bitaus(5)
        self.bitan(4) # A2 gelb
        self.warte_und_frageAb(2)
        self.bitaus(4)
        self.bitan(3)  # A2 rot
        self.warte_und_frageAb( 3)
        self.bitan(1)   # A1 rotgelb
        self.warte_und_frageAb(2)
        self.bitaus(0)
        self.bitaus(1)
        self.bitan(2) # A1 gruen
        
    def nachAmpel_2_gruen(self):
        
        self.bitaus(2)
        self.bitan(1) # A1 gelb
        self.warte_und_frageAb(2)
        self.bitaus(1)
        self.bitan(0) # A1 rot
        self.warte_und_frageAb(3) 
        self.bitan(4) # A2 rot gelb
        self.warte_und_frageAb(2)
        self.bitaus(3)
        self.bitaus(4)
        self.bitan(5) # A2 gruen
        
    def zyklus(self):
        while 1:
            self.nachAmpel_1_gruen()
            if self.angefordert:
                self.angefordert = False
                self.kenntFussampel.anforderungszyklus1()
                self.kenntFussampel.anforderungszyklus2()
                self.nachAmpel_2_gruen()
                self.warte_und_frageAb(8)
            else:
                self.warte_und_frageAb(8)
                self.nachAmpel_2_gruen()
                self.warte_und_frageAb(16)
            
class Fussgaengerampel(object):
    
    def __init__(self):
        self.test = 1
        self.outwert = 0
        self.wartezeit = 0.5
        self.cl0 = CompulabUSB4()           # Interfaceobjekt 0 schaffen
        self.cl0.INIT(0)                    # und mit 0-tem Compulab verbinden
        self.bitliste = [0,0,0,0,0,0,0,0,0] # b7 b6 b5 b4 b3 b2 b1 b0

    def testausgabe(self):
        if self.test == 1:
            print self.bitliste
            print "bitaus", self.outwert
        
    def berechne(self):
        wert = 0
        for i in self.bitliste:             # 
           wert = 2* wert + i
        return wert
    
    def bitaus(self,nr):
        self.bitliste[8-nr] = 0
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl0.DOUT(self.outwert)
        
    def bitan (self,nr):
        self.bitliste[8-nr] = 1
        self.outwert = self.berechne()
        self.testausgabe()
        self.cl0.DOUT(self.outwert)

    def angefordert(self):
        erg = self.cl0.DIN()
        if erg == 0:
            return 0
        else:
            return 1
        
    def anforderungszyklus1(self):
        sleep(self.wartezeit*2)
        self.bitan(1)   #  Fahrampel gelb
        self.bitaus(2)
        sleep(self.wartezeit*2)
        self.bitaus(1)
        self.bitan(0)   #  Fahrampel rot
        sleep(self.wartezeit*2)
        self.bitaus(3)
        self.bitan(4)   #  Anforderungsampel gruen
        sleep(self.wartezeit*6)
        for i in range (5): # Anforderungsampel blinkt gruen
            self.bitaus(4)
            sleep(self.wartezeit/2)
            self.bitan(4)
            sleep(self.wartezeit/2)
            
    def anforderungszyklus2(self):
        self.bitaus(4)
        self.bitan(3)   # Anforderungsampel rot
        sleep(self.wartezeit*5)
        self.bitan(1)   #  Fahrampel rotgelb
        sleep(self.wartezeit*2)
        self.bitaus(0)
        self.bitaus(1)
        self.bitan(2)   # Fahrampel gruen
        
    def startzustand(self):
        self.bitan(2)   # Fahrampel gruen
        self.bitan(3)   # Anforderungsampel rot
               
# Ausfuehren-------------------------

k = kreuzung()
f = Fussgaengerampel()
f.startzustand()
k.macheFussampelBekannt(f)
k.startzustand()
k.zyklus()
        
